/*
 * Decompiled with CFR 0.152.
 */
package fuzs.mutantmonsters.client.renderer.entity;

import fuzs.mutantmonsters.MutantMonsters;
import fuzs.mutantmonsters.client.init.ClientModRegistry;
import fuzs.mutantmonsters.client.model.MutantEndermanModel;
import fuzs.mutantmonsters.client.renderer.MutantRenderTypes;
import fuzs.mutantmonsters.client.renderer.entity.AlternateMobRenderer;
import fuzs.mutantmonsters.client.renderer.entity.layers.EndersoulLayer;
import fuzs.mutantmonsters.world.entity.mutant.MutantEnderman;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4048;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_4608;
import net.minecraft.class_5253;
import net.minecraft.class_5617;
import net.minecraft.class_566;
import net.minecraft.class_583;
import net.minecraft.class_776;
import net.minecraft.class_7833;

public class MutantEndermanRenderer
extends AlternateMobRenderer<MutantEnderman, class_583<MutantEnderman>> {
    private static final class_2960 TEXTURE_LOCATION = MutantMonsters.id("textures/entity/mutant_enderman/mutant_enderman.png");
    private static final class_2960 DEATH_TEXTURE_LOCATION = MutantMonsters.id("textures/entity/mutant_enderman/death.png");
    private static final class_1921 EYES_RENDER_TYPE = MutantRenderTypes.eyes(MutantMonsters.id("textures/entity/mutant_enderman/eyes.png"));
    private static final class_1921 DEATH_RENDER_TYPE = class_1921.method_23586((class_2960)TEXTURE_LOCATION);
    private final MutantEndermanModel endermanModel;
    private final class_566<MutantEnderman> cloneModel;
    private boolean teleportAttack;

    public MutantEndermanRenderer(class_5617.class_5618 context) {
        super(context, new MutantEndermanModel(context.method_32167(ClientModRegistry.MUTANT_ENDERMAN)), 0.8f);
        this.endermanModel = (MutantEndermanModel)this.field_4737;
        this.cloneModel = new class_566(context.method_32167(ClientModRegistry.ENDERMAN_CLONE));
        this.method_4046(new EyesLayer((class_3883<MutantEnderman, class_583<MutantEnderman>>)this));
        this.method_4046(new SoulLayer((class_3883<MutantEnderman, class_583<MutantEnderman>>)this));
        this.method_4046(new HeldBlocksLayer((class_3883<MutantEnderman, class_583<MutantEnderman>>)this, context.method_43337()));
    }

    public boolean shouldRender(MutantEnderman mutantEnderman, class_4604 camera, double camX, double camY, double camZ) {
        if (super.method_3933((class_1297)mutantEnderman, camera, camX, camY, camZ)) {
            return true;
        }
        if (mutantEnderman.getAnimation() == MutantEnderman.TELEPORT_ANIMATION) {
            return mutantEnderman.getTeleportPosition().map(class_243::method_24955).map(arg_0 -> ((class_4048)mutantEnderman.method_5864().method_18386()).method_30757(arg_0)).filter(arg_0 -> ((class_4604)camera).method_23093(arg_0)).isPresent();
        }
        return false;
    }

    @Override
    public void render(MutantEnderman mutantEnderman, float entityYaw, float partialTick, class_4587 poseStack, class_4597 multiBufferSource, int packedLight) {
        if (mutantEnderman.isClone()) {
            this.field_4737 = this.cloneModel;
            this.cloneModel.field_3370 = mutantEnderman.method_6510();
            this.field_4673 = 0.5f;
            this.field_4672 = 0.5f;
        } else {
            this.field_4737 = this.endermanModel;
            this.field_4673 = 0.8f;
            this.field_4672 = mutantEnderman.field_6213 > 80 ? 1.0f - MutantEndermanRenderer.getDeathProgress(mutantEnderman) : 1.0f;
        }
        this.teleportAttack = false;
        super.render(mutantEnderman, entityYaw, partialTick, poseStack, multiBufferSource, packedLight);
        if (mutantEnderman.getAnimation() == MutantEnderman.TELEPORT_ANIMATION) {
            this.teleportAttack = true;
            mutantEnderman.getTeleportPosition().ifPresent(pos -> {
                poseStack.method_22903();
                double d0 = class_3532.method_16436((double)partialTick, (double)mutantEnderman.field_6038, (double)mutantEnderman.method_23317());
                double d1 = class_3532.method_16436((double)partialTick, (double)mutantEnderman.field_5971, (double)mutantEnderman.method_23318());
                double d2 = class_3532.method_16436((double)partialTick, (double)mutantEnderman.field_5989, (double)mutantEnderman.method_23321());
                poseStack.method_22904((double)pos.method_10263() + 0.5 - d0, (double)pos.method_10264() - d1, (double)pos.method_10260() + 0.5 - d2);
                super.render(mutantEnderman, entityYaw, partialTick, poseStack, multiBufferSource, packedLight);
                poseStack.method_22909();
            });
        }
    }

    private static float getDeathProgress(MutantEnderman mutantEnderman) {
        return (float)(mutantEnderman.field_6213 - 80) / (float)(MutantEnderman.DEATH_ANIMATION.duration() - 80);
    }

    @Override
    protected boolean hasAlternateRender(MutantEnderman mutantEnderman, float partialTick, class_4587 poseStack, class_4597 multiBufferSource, int packedLight) {
        if (mutantEnderman.field_6213 > 80) {
            class_4588 vertexConsumer = multiBufferSource.getBuffer(class_1921.method_23573((class_2960)DEATH_TEXTURE_LOCATION));
            int color = class_5253.class_5254.method_59554((float)MutantEndermanRenderer.getDeathProgress(mutantEnderman), (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_4737.method_2828(poseStack, vertexConsumer, packedLight, class_4608.field_21444, color);
            vertexConsumer = multiBufferSource.getBuffer(DEATH_RENDER_TYPE);
            this.field_4737.method_60879(poseStack, vertexConsumer, packedLight, class_4608.field_21444);
            return true;
        }
        return false;
    }

    public class_243 getRenderOffset(MutantEnderman mutantEnderman, float partialTick) {
        boolean death;
        boolean stare = mutantEnderman.getAnimation() == MutantEnderman.STARE_ANIMATION;
        boolean scream = mutantEnderman.getAnimation() == MutantEnderman.SCREAM_ANIMATION;
        boolean clone = mutantEnderman.isClone() && mutantEnderman.method_6510();
        boolean telesmash = mutantEnderman.getAnimation() == MutantEnderman.TELESMASH_ANIMATION && mutantEnderman.getAnimationTick() < 18;
        boolean bl = death = mutantEnderman.getAnimation() == MutantEnderman.DEATH_ANIMATION;
        if (!(stare || scream || clone || telesmash || death)) {
            return super.method_23169((class_1297)mutantEnderman, partialTick);
        }
        double shake = 0.03;
        if (clone) {
            shake = 0.02;
        } else if (death) {
            shake = mutantEnderman.getAnimationTick() < 80 ? 0.02 : 0.05;
        } else if (mutantEnderman.getAnimationTick() >= 40) {
            shake *= 0.5;
        }
        return new class_243(mutantEnderman.method_59922().method_43059() * shake, 0.0, mutantEnderman.method_59922().method_43059() * shake);
    }

    public class_2960 getTextureLocation(MutantEnderman mutantEnderman) {
        return TEXTURE_LOCATION;
    }

    protected class_1921 getRenderType(MutantEnderman mutantEnderman, boolean bodyVisible, boolean translucent, boolean glowing) {
        return mutantEnderman.isClone() ? null : super.method_24302((class_1309)mutantEnderman, bodyVisible, translucent, glowing);
    }

    protected float getFlipDegrees(MutantEnderman mutantEnderman) {
        return 0.0f;
    }

    static class EyesLayer
    extends class_3887<MutantEnderman, class_583<MutantEnderman>> {
        public EyesLayer(class_3883<MutantEnderman, class_583<MutantEnderman>> renderer) {
            super(renderer);
        }

        public void render(class_4587 poseStack, class_4597 multiBufferSource, int packedLight, MutantEnderman mutantEnderman, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
            if (!mutantEnderman.isClone()) {
                class_4588 ivertexbuilder = multiBufferSource.getBuffer(EYES_RENDER_TYPE);
                float alpha = mutantEnderman.field_6213 > 80 ? 1.0f - MutantEndermanRenderer.getDeathProgress(mutantEnderman) : 1.0f;
                int color = class_5253.class_5254.method_59554((float)alpha, (float)1.0f, (float)1.0f, (float)1.0f);
                this.method_17165().method_2828(poseStack, ivertexbuilder, 0xF00000, class_4608.field_21444, color);
            }
        }
    }

    class SoulLayer
    extends EndersoulLayer<MutantEnderman, class_583<MutantEnderman>> {
        public SoulLayer(class_3883<MutantEnderman, class_583<MutantEnderman>> renderer) {
            super(renderer);
        }

        @Override
        public void render(class_4587 poseStack, class_4597 multiBufferSource, int packedLight, MutantEnderman mutantEnderman, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
            boolean teleport = mutantEnderman.getAnimation() == MutantEnderman.TELEPORT_ANIMATION && mutantEnderman.getAnimationTick() < 10;
            boolean scream = mutantEnderman.getAnimation() == MutantEnderman.SCREAM_ANIMATION;
            boolean clone = mutantEnderman.isClone();
            if (teleport || scream || clone) {
                float scale = 0.0f;
                if (teleport) {
                    scale = 1.2f + ((float)mutantEnderman.getAnimationTick() + partialTick) / 10.0f;
                    if (MutantEndermanRenderer.this.teleportAttack) {
                        scale = 2.2f - ((float)mutantEnderman.getAnimationTick() + partialTick) / 10.0f;
                    }
                }
                if (scream) {
                    scale = mutantEnderman.getAnimationTick() < 40 ? 1.2f + ((float)mutantEnderman.getAnimationTick() + partialTick) / 40.0f : (mutantEnderman.getAnimationTick() < 160 ? 2.2f : Math.max(0.0f, 2.2f - ((float)mutantEnderman.getAnimationTick() + partialTick) / 10.0f));
                }
                poseStack.method_22903();
                if (!clone) {
                    poseStack.method_22905(scale, scale * 0.8f, scale);
                }
                super.render(poseStack, multiBufferSource, packedLight, mutantEnderman, limbSwing, limbSwingAmount, partialTick, ageInTicks, netHeadYaw, headPitch);
                poseStack.method_22909();
            }
        }

        @Override
        protected float getAlpha(MutantEnderman mutantEnderman, float partialTick) {
            float alpha = 1.0f;
            if (mutantEnderman.getAnimation() == MutantEnderman.TELEPORT_ANIMATION) {
                if (!MutantEndermanRenderer.this.teleportAttack && mutantEnderman.getAnimationTick() >= 8) {
                    alpha -= ((float)mutantEnderman.getAnimationTick() - 8.0f + partialTick) / 2.0f;
                }
                if (MutantEndermanRenderer.this.teleportAttack && mutantEnderman.getAnimationTick() < 2) {
                    alpha = ((float)mutantEnderman.getAnimationTick() + partialTick) / 2.0f;
                }
            }
            if (mutantEnderman.getAnimation() == MutantEnderman.SCREAM_ANIMATION) {
                if (mutantEnderman.getAnimationTick() < 40) {
                    alpha = ((float)mutantEnderman.getAnimationTick() + partialTick) / 40.0f;
                } else if (mutantEnderman.getAnimationTick() >= 160) {
                    alpha = 1.0f - ((float)mutantEnderman.getAnimationTick() + partialTick) / 40.0f;
                }
            }
            return alpha;
        }
    }

    static class HeldBlocksLayer
    extends class_3887<MutantEnderman, class_583<MutantEnderman>> {
        private final class_776 blockRenderer;

        public HeldBlocksLayer(class_3883<MutantEnderman, class_583<MutantEnderman>> renderer, class_776 blockRenderer) {
            super(renderer);
            this.blockRenderer = blockRenderer;
        }

        public void render(class_4587 poseStack, class_4597 multiBufferSource, int packedLight, MutantEnderman mutantEnderman, float limbSwing, float limbSwingAmount, float partialTick, float ageInTicks, float netHeadYaw, float headPitch) {
            class_583 class_5832;
            if (mutantEnderman.getAnimation() != MutantEnderman.CLONE_ANIMATION && (class_5832 = this.method_17165()) instanceof MutantEndermanModel) {
                MutantEndermanModel model = (MutantEndermanModel)class_5832;
                for (int i = 0; i < 4; ++i) {
                    if (mutantEnderman.getHeldBlock(i) <= 0) continue;
                    poseStack.method_22903();
                    model.translateRotateArm(poseStack, i);
                    poseStack.method_22904(0.0, 1.2, 0.0);
                    float tick = (float)mutantEnderman.field_6012 + (float)(i + 1) * 2.0f * (float)Math.PI + partialTick;
                    poseStack.method_22907(class_7833.field_40714.rotationDegrees(tick * 10.0f));
                    poseStack.method_22907(class_7833.field_40716.rotationDegrees(tick * 8.0f));
                    poseStack.method_22907(class_7833.field_40718.rotationDegrees(tick * 6.0f));
                    poseStack.method_22905(-0.75f, -0.75f, 0.75f);
                    poseStack.method_22904(-0.5, -0.5, 0.5);
                    poseStack.method_22907(class_7833.field_40716.rotationDegrees(90.0f));
                    this.blockRenderer.method_3353(class_2248.method_9531((int)mutantEnderman.getHeldBlock(i)), poseStack, multiBufferSource, packedLight, class_4608.field_21444);
                    poseStack.method_22909();
                }
            }
        }
    }
}

